#!/bin/bash

mountPoint=/mnt/usb
translationFile=$mountPoint/override_translation.qm
backlightDevice=/sys/class/backlight/backlight/brightness

function turnOffBacklight() {
     echo 0 > $backlightDevice
}

function turnOnBacklight() {
     echo 7 > $backlightDevice
}

function mountUsb() {
    if [ -e /dev/sda1 ]; then
       mount /dev/sda1 $mountPoint
    elif [ -e /dev/sda ]; then
       mount /dev/sda $mountPoint
    fi
}

function unmountUsb() {
    if hasOverrideTranslation; then
        echo "not unmounting USB as it contains $translationFile"
        return
    fi

    umount $mountPoint

    #belt and braces approach
    if cat /proc/mounts | grep $mountPoint ; then
       echo "unmounting $mountPoint"
       umount $mountPoint
    else
       echo "no need to unmount $mountPoint!"
    fi
}

function hasOverrideTranslation() {
    if [ -e $translationFile ]; then
        return 0
    fi

    return 1
}

function factoryReset() {
    if [ ! -e "/tmp/lantek_factory_reset" ]; then
        return
    fi
    rm -f /tmp/lantek_factory_reset
    cd /opt/LanTEK/data/
    rm -rf *.db config.ini fiber_inspection
    cd -
    truncate -s 0 /var/log/daemon.log
    sleep 1
    sync
    sync
    sync
    sleep 1
}

#minimise backlight brightness
#turnOffBacklight

#mount USB
mountUsb

#unmount USB if necessary
unmountUsb

#do factory reset if required
factoryReset

#max backlight brightness - will be removed when LanTEKGui takes control of the backlight.
#turnOnBacklight

#start LanEK application export
export LD_LIBRARY_PATH=/opt/LanTEK/lib
export ASAN_OPTIONS=alloc_dealloc_mismatch=0,new_delete_type_mismatch=0,memcpy-param-overlap=0,halt_on_error=0
export QT_LOGGING_CONF=/opt/LanTEK/data/qtLogging.ini
declare -i status=0;

/opt/LanTEK/bin/LanTEKConsole

#LanTEKGui has exited .. play shutdown sound if clean exit..
retVal=$?

#turnOffBacklight

if [ $retVal -ne 0 ]; then
    echo "LanTEKConsole returned Error "$retVal
    #lantek.service will 'restart=on-failure' 
    #provided we exit with the non-zero value here...
    exit $retVal
fi
